<?php
// modules/excursions/backend/routes_form.php
// Админка: форма Создания/Редактирования экскурсии (Основное)

ini_set('display_errors',1);
error_reporting(E_ALL);
?>
<!DOCTYPE html>
<html lang="ru">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Менеджер экскурсий — Основное</title>
  <style>
    body { font-family: Arial, sans-serif; margin:20px; }
    fieldset { margin-top:20px; border:1px solid #ccc; padding:10px; }
    legend { font-weight:bold; }
    label { display:block; margin-top:10px; }
    input, textarea, select { width:100%; padding:8px; margin-top:4px; box-sizing:border-box; }
    #coverPreview { margin-top:10px; max-width:200px; }
    button { padding:10px 20px; margin-top:20px; font-size:16px; cursor:pointer; }
    #languages label { display:inline-block; margin-right:10px; }
  </style>
</head>
<body>
  <h1 id="formTitle">Создать новую экскурсию</h1>
  <form id="routeForm">
    <label>Название тура
      <input type="text" id="name" required maxlength="100" />
    </label>
    <label>Описание
      <textarea id="description" rows="5"></textarea>
    </label>
    <label>Обложка
      <input type="file" id="cover" accept="image/png,image/jpeg,image/webp" />
      <img id="coverPreview" src="" alt="Превью обложки" />
    </label>
    <label>Статус
      <select id="status">
        <option value="draft">Черновик</option>
        <option value="published">Опубликовано</option>
      </select>
    </label>
    <label>Страна
      <select id="country"></select>
    </label>
    <label>Город
      <select id="city"></select>
    </label>
    <label>Длительность
      <input type="number" id="durationHours" min="0" placeholder="Часы" />
      <input type="number" id="durationMinutes" min="0" max="59" placeholder="Минуты" />
    </label>
    <fieldset>
      <legend>Языки тура</legend>
      <div id="languages"></div>
    </fieldset>
    <button type="button" id="saveBtn">Сохранить</button>
    <button type="button" id="nextBtn">Далее: Маршрут</button>
    <button type="button" id="cancelBtn">Отмена</button>
  </form>

  <script>
  (function(){
    const form = document.getElementById('routeForm');
    const params = new URLSearchParams(window.location.search);
    const routeId = params.get('id');

    // Загрузить справочники: страны и динамические языки
    async function loadLookups(){
      // Страны
      const countries = ['Германия','Италия','Франция','Польша'];
      const countrySel = document.getElementById('country');
      countries.forEach(c => countrySel.add(new Option(c, c)));

      // Динамические языки
      try {
        const res = await fetch('/modules/excursions/backend/api/languages.php');
        if (!res.ok) throw new Error('Ошибка загрузки языков: ' + res.status);
        const langs = await res.json();
        const container = document.getElementById('languages');
        container.innerHTML = '';
        langs.forEach(l => {
          const label = document.createElement('label');
          label.innerHTML = `<input type="checkbox" value="${l.code}" /> ${l.name}`;
          container.append(label);
        });
      } catch(e) {
        alert(e.message);
      }
    }

    // Загрузить данные экскурсии для редактирования
    async function loadRoute(){
      if (!routeId) return;
      document.getElementById('formTitle').textContent = 'Редактировать экскурсию';
      const res = await fetch(`/modules/excursions/backend/api/routes.php?id=${routeId}`);
      const data = await res.json();
      document.getElementById('name').value = data.name;
      document.getElementById('description').value = data.description;
      document.getElementById('status').value = data.status;
      document.getElementById('country').value = data.country;
      // TODO: загрузить города
      document.getElementById('city').value = data.city;
      document.getElementById('durationHours').value = data.duration_hours;
      document.getElementById('durationMinutes').value = data.duration_minutes;
      // Отметить языки
      (data.languages || []).forEach(code => {
        const cb = document.querySelector(`#languages input[value="${code}"]`);
        if (cb) cb.checked = true;
      });
      if (data.cover_url) document.getElementById('coverPreview').src = data.cover_url;
    }

    // Сохранение экскурсии
    document.getElementById('saveBtn').addEventListener('click', async ()=>{
      const fd = new FormData();
      fd.append('name', document.getElementById('name').value);
      fd.append('description', document.getElementById('description').value);
      fd.append('status', document.getElementById('status').value);
      fd.append('country', document.getElementById('country').value);
      fd.append('city', document.getElementById('city').value);
      fd.append('duration_hours', document.getElementById('durationHours').value);
      fd.append('duration_minutes', document.getElementById('durationMinutes').value);
      document.querySelectorAll('#languages input:checked').forEach(cb => fd.append('languages[]', cb.value));
      const coverFile = document.getElementById('cover').files[0];
      if (coverFile) fd.append('cover', coverFile);

      const url = routeId ? `/modules/excursions/backend/api/routes.php?id=${routeId}`
                         : '/modules/excursions/backend/api/routes.php';
      const method = routeId ? 'PUT' : 'POST';
      const res = await fetch(url, { method, body: fd });
      if (res.ok) alert('Сохранено'); else alert('Ошибка ' + res.status);
    });

    // Переход к маршруту
    document.getElementById('nextBtn').addEventListener('click', ()=>{
      document.getElementById('saveBtn').click();
      window.location.href = `/modules/excursions/backend/routes_map.php?id=${routeId || ''}`;
    });

    // Отмена
    document.getElementById('cancelBtn').addEventListener('click', ()=>{
      if (confirm('Отменить изменения?')) window.location.href = '/modules/excursions/backend/routes_admin.php';
    });

    // Инициализация
    loadLookups().then(loadRoute);
  })();
  </script>
</body>
</html>
