<?php
// modules/excursions/backend/routes_wizard.php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/../../../config/db.php';
session_start();
?>
<!DOCTYPE html>
<html lang="ru">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1.0"/>
  <link rel="icon" href="data:;base64,iVBORw0KGgo=">
  <title>Конструктор маршрутов</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet@1.9.3/dist/leaflet.css"/>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet-draw@1.0.4/dist/leaflet.draw.css"/>
  <link rel="stylesheet" href="routes_wizard.css"/>
</head>
<body>
  <div id="wizard" style="max-width:900px;margin:0 auto;padding:20px;">
    <h1>Конструктор маршрутов</h1>
    <div id="notification" style="display:none;margin:8px 0;padding:8px;"></div>
    <ul id="steps" style="display:flex;list-style:none;padding:0;margin:16px 0;">
      <li data-step="1" class="active" style="flex:1;text-align:center;cursor:pointer;">1. Основное</li>
      <li data-step="2" style="flex:1;text-align:center;cursor:pointer;">2. POI</li>
      <li data-step="3" style="flex:1;text-align:center;cursor:pointer;">3. Маршрут</li>
      <li data-step="4" style="flex:1;text-align:center;cursor:pointer;">4. Превью</li>
    </ul>
    <div id="content" style="min-height:500px;"></div>
    <div id="actions" style="margin-top:16px;text-align:right;">
      <button id="prevBtn" disabled style="padding:8px 16px;">Назад</button>
      <button id="nextBtn" style="padding:8px 16px;">Далее</button>
    </div>
  </div>

  <!-- Leaflet & Draw -->
  <script src="https://cdn.jsdelivr.net/npm/leaflet@1.9.3/dist/leaflet.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/leaflet-draw@1.0.4/dist/leaflet.draw.js"></script>
  <!-- Шаги -->
  <script src="js/routes_wizard_step1.js"></script>
  <script src="js/routes_wizard_step2.js"></script>
  <script src="js/osm_tourism_overlay.js"></script>
  <script src="js/routes_wizard_step3.js"></script>

  <script>
  (function(){
    const steps   = Array.from(document.querySelectorAll('#steps li'));
    const content = document.getElementById('content');
    const prevBtn = document.getElementById('prevBtn');
    const nextBtn = document.getElementById('nextBtn');
    const notify  = document.getElementById('notification');
    let current = 1, routeId = null;

    function showNotification(msg,type){
      notify.textContent = msg;
      notify.style.display = 'block';
      notify.style.background = type==='success'? '#28a745':'#dc3545';
      notify.style.color = '#fff';
    }
    function clearNotification(){
      notify.style.display = 'none';
    }

    function renderStep(n){
      current = n;
      steps.forEach(li=>{
        const s = +li.dataset.step;
        li.classList.toggle('active', s===n);
        li.classList.toggle('done',   s<n);
      });
      prevBtn.disabled = (n===1);
      nextBtn.textContent = (n===steps.length ? 'Опубликовать' : 'Далее');
      clearNotification();
      if(n===1) showStep1();
      else if(n===2) showStep2();
      else if(n===3) showStep3();
      else showStep4();
    }

    // --- Шаг 1: Основное ---
    function showStep1(){
      content.innerHTML = `
        <form id="step1" style="display:flex;flex-direction:column;gap:12px;">
          <label>Название*<br><input type="text" id="name" required></label>
          <label>Описание*<br><textarea id="description" rows="3" required></textarea></label>
          <label>Статус<br>
            <select id="status">
              <option value="draft">Черновик</option>
              <option value="published">Опубликовано</option>
            </select>
          </label>
          <label>Фото-обложка<br><input type="file" id="cover_image"></label>
          <label>Язык аудиогида<br>
            <select id="language_code" required>
              <option value="ru">Русский</option>
              <option value="en">English</option>
              <option value="de">Deutsch</option>
            </select>
          </label>
          <label>Сложность<br>
            <select id="difficulty">
              <option>Лёгкий</option>
              <option>Средний</option>
              <option>Сложный</option>
            </select>
          </label>
          <label>Страна*<br><input list="country-list" id="country" autocomplete="off" required></label>
          <datalist id="country-list"></datalist>
          <label>Город*<br><input list="city-list" id="city" autocomplete="off" required disabled></label>
          <datalist id="city-list"></datalist>

          <!-- Контейнер для переключателя автопоиска / ручного ввода -->
          <div id="step1Hint" style="margin:8px 0;color:#555;"></div>

          <div id="step1Map" style="height:250px;margin:8px 0;"></div>
          <div style="display:flex;gap:8px;">
            <label>Широта<br><input type="text" id="cityLat" readonly></label>
            <label>Долгота<br><input type="text" id="cityLng" readonly></label>
          </div>
        </form>`;
      initStep1Module();
    }
    async function saveStep1(){
      if(!saveStep1Module()) return;
      const frm = new FormData(document.getElementById('step1'));
      const img = document.getElementById('cover_image').files[0];
      if(img) frm.append('cover_image', img);
      try {
        const res = await fetch('/modules/excursions/backend/api/routes.php',{
          method:'POST', body:frm
        });
        const json = await res.json();
        if(json.id){
          routeId = json.id;
          window.routeLat = document.getElementById('cityLat').value;
          window.routeLng = document.getElementById('cityLng').value;
          showNotification('Шаг 1 сохранён','success');
          renderStep(2);
        } else {
          showNotification('Ошибка сохранения','error');
        }
      } catch {
        showNotification('Сетевая ошибка','error');
      }
    }

    // --- Шаг 2: POI ---
    function showStep2(){
      content.innerHTML = `
        <button id="addPoi">+ Добавить POI</button>
        <button id="toggleTourism" style="margin-left:8px;">Показать другие объекты</button>
        <div id="poiHint" style="margin:8px 0;color:#555;"></div>
        <div id="map2" style="height:300px;margin:8px 0;"></div>
        <div id="poiList"></div>
        <div id="poiForm"></div>
        <button id="savePoi" disabled>Сохранить POI</button>
        <button id="cancelPoi">Отмена</button>
      `;
      initStep2Module(routeId, window.routeLat, window.routeLng);
    }

    // --- Шаг 3: Маршрут ---
    function showStep3(){
      content.innerHTML = `
        <h2>Шаг 3: Маршрут</h2>
        <p class="wizard-hint">
          Нарисуйте линию маршрута или нажмите «Авто-маршрут» для соединения POI.
        </p>
        <div style="margin-bottom:8px;">
          <button id="autoRoute" style="margin-right:8px;">Авто-маршрут</button>
          <button id="saveRoute">Сохранить маршрут</button>
        </div>
        <div id="map3" style="height:400px;margin:8px 0;"></div>
      `;
      initStep3Module(routeId, window.routeLat, window.routeLng);
      document.getElementById('autoRoute').onclick = autoRoute;
    }

    // --- Шаг 4: Превью ---
    function showStep4(){
      content.innerHTML = `
        <h2>Шаг 4: Превью</h2>
        <iframe src="/modules/excursions/frontend/excursion.html?id=${routeId}&lang=ru"
                style="width:100%;height:400px;border:1px solid #ccc;"></iframe>
      `;
    }

    // Навигация
    prevBtn.onclick = ()=>{ if(current>1) renderStep(current-1); };
    nextBtn.onclick = ()=>{
      if(current===1) return saveStep1();
      if(current===2) return renderStep(3);
      if(current===3) return renderStep(4);
      alert(`Экскурсия опубликована! ID=${routeId}`);
    };
    steps.forEach(li=>li.addEventListener('click',()=>{
      const s = +li.dataset.step;
      if(s<=current+1) renderStep(s);
    }));

    // Запуск
    renderStep(1);
  })();
  </script>
</body>
</html>
