<?php
// modules/maps/backend/tracker.php

header('Content-Type: application/json');

// Читаем driver_id из GET
$driverId = isset($_GET['driver_id']) ? intval($_GET['driver_id']) : 0;

// Путь к файлу позиций
$positionsFile = __DIR__ . '/positions.json';

// Если есть сохранённая позиция — отдадим её
if (file_exists($positionsFile)) {
    $json = file_get_contents($positionsFile);
    $positions = json_decode($json, true) ?: [];
    
    if (isset($positions[$driverId])) {
        $pt = $positions[$driverId];
        echo json_encode([
            'driver_id' => $driverId,
            'lat'       => $pt['lat'],
            'lng'       => $pt['lng'],
            'timestamp' => $pt['timestamp']
        ]);
        exit;
    }
}

// Фолбэк — центр Киева
echo json_encode([
    'driver_id' => $driverId,
    'lat'       => 50.4501,
    'lng'       => 30.5234,
    'timestamp' => null
]);
