<?php
// get_messages.php
header('Content-Type: application/json');

$sessionsFile = __DIR__ . '/sessions.json';
$sessionId    = $_GET['session']  ?? '';
$lastId       = intval($_GET['last_id'] ?? 0);

if (!$sessionId) {
    http_response_code(400);
    echo json_encode(['error' => 'Не указан session']);
    exit;
}

if (!file_exists($sessionsFile)) {
    http_response_code(500);
    echo json_encode(['error' => 'sessions.json не найден']);
    exit;
}

$sessionsJson = file_get_contents($sessionsFile);
$sessions = json_decode($sessionsJson, true);

if (!isset($sessions[$sessionId])) {
    http_response_code(404);
    echo json_encode(['error' => 'Сессия не найдена']);
    exit;
}

$allMessages = $sessions[$sessionId]['messages'] ?? [];
$newMessages = [];

// Собираем все сообщения с id > lastId
foreach ($allMessages as $msg) {
    if (isset($msg['id']) && intval($msg['id']) > $lastId) {
        $newMessages[] = $msg;
    }
}

// Возвращаем массив новых сообщений (может быть пустым)
echo json_encode($newMessages);
