<?php
// register_language.php
header('Content-Type: application/json; charset=UTF-8');

$sessionsFile = __DIR__ . '/sessions.json';

// Получаем из GET: session и lang
$sessionId = $_GET['session'] ?? '';
$lang = $_GET['lang'] ?? '';

// Простейшая валидация
if (!$sessionId || !$lang) {
    http_response_code(400);
    echo json_encode(['error' => 'Не указан session или lang']);
    exit;
}

// Убедимся, что sessions.json существует
if (!file_exists($sessionsFile)) {
    http_response_code(500);
    echo json_encode(['error' => 'sessions.json не найден']);
    exit;
}

// Прочитаем и распарсим
$json = file_get_contents($sessionsFile);
$sessions = json_decode($json, true);
if ($sessions === null) {
    http_response_code(500);
    echo json_encode(['error' => 'Не удалось распарсить sessions.json']);
    exit;
}

// Убедимся, что сессия есть
if (!isset($sessions[$sessionId])) {
    http_response_code(404);
    echo json_encode(['error' => 'Сессия не найдена']);
    exit;
}

// Определим, какой стороне присвоить язык: A или B
$entry = &$sessions[$sessionId];
// Если langA ещё пуст, и langB пуст (первая регистрация) — присваиваем langA
if (empty($entry['langA'])) {
    $entry['langA'] = $lang;
    $side = 'A';
    $partnerLang = $entry['langB'] ?? null;
}
// Если langA задан, а langB пуст — присваиваем langB
elseif (empty($entry['langB'])) {
    // Если lang уже совпадает с langA, всё равно считаем, что это B (две стороны могут одинаковый язык)
    $entry['langB'] = $lang;
    $side = 'B';
    $partnerLang = $entry['langA'];
}
// Если оба языка уже заданы (кто-то кликает ещё раз), определим стороны по совпадению
else {
    if ($entry['langA'] === $lang) {
        $side = 'A';
        $partnerLang = $entry['langB'];
    } elseif ($entry['langB'] === $lang) {
        $side = 'B';
        $partnerLang = $entry['langA'];
    } else {
        // Здесь может быть ситуация, что оба языковых слота уже заняты другими значениями
        http_response_code(409);
        echo json_encode(['error' => 'Оба языковых слота уже заняты']);
        exit;
    }
}

// Проверим, зарегистрированы ли оба
$bothRegistered = !empty($entry['langA']) && !empty($entry['langB']);

// Сохраняем обратно в sessions.json
file_put_contents($sessionsFile, json_encode($sessions, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));

// Отвечаем JSON с информацией для PWA
echo json_encode([
    'bothRegistered' => $bothRegistered,
    'side'           => $side,
    'partnerLang'    => $partnerLang
]);
