<?php
// public_html/v.centrx.eu/api/tts.php

// Отдаём MPEG-аудио
header('Content-Type: audio/mpeg');

// Читаем входящий JSON
$payload = json_decode(file_get_contents('php://input'), true);
$text    = $payload['text'] ?? '';
$lang    = $payload['lang'] ?? 'en';

if (!$text) {
    http_response_code(400);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['error' => 'Empty text']);
    exit;
}

// Разбиваем на фрагменты до 200 символов
$chunks = str_split($text, 200);

// Собираем аудио
foreach ($chunks as $chunk) {
    $url = 'https://translate.google.com/translate_tts?ie=UTF-8'
         . '&q=' . rawurlencode($chunk)
         . '&tl=' . $lang
         . '&client=tw-ob';
    echo file_get_contents($url);
}
