<?php
// modules/excursions/backend/cleanup.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Подключение к базе
require_once __DIR__ . '/../../../config/db.php';

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Отключаем проверку внешних ключей
        $pdo->exec("SET FOREIGN_KEY_CHECKS = 0");

        // Очищаем таблицы
        $pdo->exec("TRUNCATE TABLE poi_translations");
        $pdo->exec("TRUNCATE TABLE pois");
        $pdo->exec("TRUNCATE TABLE routes");
        // Если нужно очистить сессии, раскомментируйте:
//      $pdo->exec("TRUNCATE TABLE sessions");

        // Сбрасываем автоинкремент
        $pdo->exec("ALTER TABLE routes AUTO_INCREMENT = 1");
        $pdo->exec("ALTER TABLE pois   AUTO_INCREMENT = 1");
//      $pdo->exec("ALTER TABLE sessions AUTO_INCREMENT = 1");

        // Вновь включаем проверку FK
        $pdo->exec("SET FOREIGN_KEY_CHECKS = 1");

        $message = 'Очистка базы успешно выполнена.';
    } catch (\Exception $e) {
        // На случай ошибки возвращаем FK-чекбек
        $pdo->exec("SET FOREIGN_KEY_CHECKS = 1");
        $message = 'Ошибка при очистке: ' . htmlspecialchars($e->getMessage());
    }
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1.0">
  <title>Очистка тестовых данных</title>
  <style>
    body { font-family: Arial, sans-serif; max-width:600px; margin:40px auto; }
    .btn { padding:10px 20px; font-size:16px; }
    .msg { margin:20px 0; padding:12px; border-radius:4px; }
    .success { background:#e6ffed; color:#22863a; border:1px solid #2ea44f; }
    .error   { background:#ffeef0; color:#86181d; border:1px solid #d73a49; }
  </style>
</head>
<body>
  <h1>Очистка тестовых данных</h1>
  <p>Нажмите кнопку ниже, чтобы удалить все тестовые маршруты и POI из базы и сбросить счётчики.</p>

  <?php if ($message): ?>
    <div class="msg <?= strpos($message, 'Ошибка') === 0 ? 'error' : 'success' ?>">
      <?= nl2br(htmlspecialchars($message)) ?>
    </div>
  <?php endif; ?>

  <form method="post">
    <button type="submit" class="btn">Запустить очистку</button>
  </form>
</body>
</html>
