// modules/excursions/backend/js/routes_wizard_step1.js
(function(){
  let map1, marker1;
  let countryInput, cityInput, cityLatInput, cityLngInput;
  let cityFeatures = [];
  let selectedCountryCode = '';
  let manualMode = false;

  function initStep1Module(){
    // --- карта ---
    if (!map1) {
      map1 = L.map('step1Map').setView([50,10],4);
      L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',{maxZoom:19})
        .addTo(map1);
      if(window.addTourismLayer) window.addTourismLayer(map1);

      marker1 = L.marker([50,10],{draggable:true}).addTo(map1);
      marker1.on('dragend', e=>{
        const p = e.target.getLatLng();
        cityLatInput.value = p.lat.toFixed(6);
        cityLngInput.value = p.lng.toFixed(6);
      });
      map1.on('click', e=>{
        if(manualMode) return;
        marker1.setLatLng(e.latlng);
        cityLatInput.value = e.latlng.lat.toFixed(6);
        cityLngInput.value = e.latlng.lng.toFixed(6);
      });
    }

    countryInput  = document.getElementById('country');
    cityInput     = document.getElementById('city');
    cityLatInput  = document.getElementById('cityLat');
    cityLngInput  = document.getElementById('cityLng');

    // --- режимы ввода ---
    const hint = document.getElementById('step1Hint');
    hint.innerHTML = `
      <button id="modeAuto">Автопоиск</button>
      <button id="modeManual">Ручной ввод</button>
      <div id="manualCoords" style="display:none;margin-top:8px;">
        <label>Широта:<br><input type="number" step="0.000001" id="manualLat"></label><br>
        <label>Долгота:<br><input type="number" step="0.000001" id="manualLng"></label><br>
        <button id="applyCityCoords">Найти на карте</button>
      </div>
    `;
    document.getElementById('modeAuto').onclick   = ()=>switchCityMode(false);
    document.getElementById('modeManual').onclick = ()=>switchCityMode(true);
    document.getElementById('applyCityCoords').onclick = applyCityCoords;

    // --- список стран ---
    fetch('/modules/excursions/backend/data/countries.json')
      .then(r=>r.json())
      .then(list=>{
        const dl = document.getElementById('country-list');
        dl.innerHTML = '';
        list.forEach(c=>{
          const opt = document.createElement('option');
          opt.value = c.name;
          opt.dataset.code = c.code.toLowerCase();
          dl.appendChild(opt);
        });
      }).catch(console.error);

    countryInput.addEventListener('change', onCountryChange);
    cityInput.addEventListener('input', onCityInput);
    cityInput.addEventListener('change', onCitySelect);
  }

  function switchCityMode(toManual){
    manualMode = toManual;
    document.getElementById('manualCoords').style.display = toManual ? 'block' : 'none';
    cityInput.disabled = toManual; // в ручном режиме отключаем автодаталист
  }

  function onCountryChange(){
    const name = countryInput.value;
    const opt = document.querySelector(`#country-list option[value="${name}"]`);
    selectedCountryCode = opt ? opt.dataset.code : '';
    fetch(`https://nominatim.openstreetmap.org/search?country=${encodeURIComponent(name)}&format=json&limit=1`)
      .then(r=>r.json())
      .then(res=>{
        if(res[0]?.boundingbox){
          const b = res[0].boundingbox;
          map1.fitBounds([[b[0],b[2]],[b[1],b[3]]]);
        }
      }).catch(console.error);
    cityInput.disabled = false;
  }

  function onCityInput(e){
    if(manualMode) return;
    const q = e.target.value;
    if(q.length < 3) return;
    fetch(`https://nominatim.openstreetmap.org/search?city=${encodeURIComponent(q)}&countrycodes=${selectedCountryCode}&format=json&limit=5`)
      .then(r=>r.json())
      .then(data=>{
        cityFeatures = data;
        const dl = document.getElementById('city-list');
        dl.innerHTML = '';
        data.forEach(item=>{
          const opt = document.createElement('option');
          // покидаем только короткое название
          opt.value = item.address && item.address.city
                    ? item.address.city
                    : item.display_name.split(',')[0];
          dl.appendChild(opt);
        });
      }).catch(console.error);
  }

  function onCitySelect(e){
    if(manualMode) return;
    const val = e.target.value;
    const match = cityFeatures.find(f=>{
      const short = f.address?.city || f.display_name.split(',')[0];
      return short === val;
    });
    if(!match) return;
    const lat = parseFloat(match.lat), lon = parseFloat(match.lon);
    marker1.setLatLng([lat,lon]);
    map1.setView([lat,lon],12);
    cityLatInput.value = lat.toFixed(6);
    cityLngInput.value = lon.toFixed(6);
    // сохраняем в поле только короткое название
    cityInput.value = match.address?.city || match.display_name.split(',')[0];
  }

  function applyCityCoords(){
    const la = parseFloat(document.getElementById('manualLat').value);
    const ln = parseFloat(document.getElementById('manualLng').value);
    if(isNaN(la)||la<-90||la>90||isNaN(ln)||ln<-180||ln>180){
      return alert('Координаты должны быть: широта −90…+90, долгота −180…+180');
    }
    marker1.setLatLng([la,ln]);
    map1.setView([la,ln],12);
    cityLatInput.value = la.toFixed(6);
    cityLngInput.value = ln.toFixed(6);
    // оставляем cityInput пустым, пользователь впишет вручную
    cityInput.value = '';
    cityInput.disabled = false;
  }

  function saveStep1Module(){
    const form = document.getElementById('step1');
    if(!form.checkValidity() || !cityLatInput.value){
      showNotification('Заполните все обязательные поля и укажите город/координаты','error');
      return false;
    }
    return true;
  }

  window.initStep1Module   = initStep1Module;
  window.saveStep1Module   = saveStep1Module;
})();
