// modules/excursions/backend/js/routes_wizard_step3.js
(function(){
  let map3, drawnItems, routeId;

  // Инициализация Шага 3: Маршрут
  window.initStep3Module = async function(rId, latStr, lngStr){
    routeId = rId;
    const lat = parseFloat(latStr), lng = parseFloat(lngStr);
    const center = (isFinite(lat)&&isFinite(lng))? [lat,lng] : [47.7261,10.3172];

    // 1) Карта
    map3 = L.map('map3').setView(center,13);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',{maxZoom:19})
      .addTo(map3);

    // 2) Заготовка для рисунка
    drawnItems = new L.FeatureGroup().addTo(map3);
    new L.Control.Draw({
      edit: { featureGroup: drawnItems },
      draw: { 
        polyline: { shapeOptions:{color:'blue',weight:4} },
        polygon:false,rectangle:false,circle:false,marker:false
      }
    }).addTo(map3);

    // 3) Подгрузить и нарисовать сохранённый маршрут
    try {
      const res = await fetch(`/modules/excursions/backend/api/routes.php?id=${routeId}`);
      if(res.ok){
        const data = await res.json();
        if(data.polyline){
          const coords = JSON.parse(data.polyline).map(pt=>[pt[1],pt[0]]);
          const pl = L.polyline(coords,{color:'blue',weight:4});
          drawnItems.addLayer(pl);
          map3.fitBounds(pl.getBounds());
        }
      }
    } catch(e){
      console.error('Ошибка загрузки маршрута:',e);
    }

    // 4) Подгрузить и отобразить POI-маркеры
    try {
      const res2 = await fetch(`/modules/excursions/backend/api/pois.php?route_id=${routeId}`);
      const pois = res2.ok? await res2.json() : [];
      pois.forEach(p=>{
        const latN = parseFloat(p.lat), lngN = parseFloat(p.lng);
        L.marker([latN,lngN],{title:`#${p.poi_order}`})
          .addTo(map3)
          .bindPopup(`POI #${p.poi_order}`);
      });
    } catch(e){
      console.error('Ошибка загрузки POI:',e);
    }

    // 5) Обработчик нарисованной линии
    map3.on(L.Draw.Event.CREATED, e=>{
      drawnItems.clearLayers();
      drawnItems.addLayer(e.layer);
    });

    // 6) Кнопка сохранения
    document.getElementById('saveRoute').onclick = saveRoute;
  };

  // Автоматическое соединение POI
  async function autoRoute(){
    try {
      const res = await fetch(`/modules/excursions/backend/api/pois.php?route_id=${routeId}`);
      const pois = res.ok? await res.json() : [];
      pois.sort((a,b)=>a.poi_order-b.poi_order);
      const latlngs = pois.map(p=>[parseFloat(p.lat),parseFloat(p.lng)]);
      drawnItems.clearLayers();
      const pl = L.polyline(latlngs,{color:'blue',weight:4});
      drawnItems.addLayer(pl);
      map3.fitBounds(pl.getBounds());
    } catch(e){
      console.error('Ошибка авто-маршрута:',e);
      alert('Не удалось сгенерировать маршрут');
    }
  }

  // Сохранение маршрута
  async function saveRoute(){
    if(!drawnItems.getLayers().length){
      return alert('Сначала нарисуйте маршрут или нажмите «Авто-маршрут»');
    }
    const latlngs = drawnItems.getLayers()[0].getLatLngs()
      .map(p=>[p.lng,p.lat]); // [lng,lat]
    try {
      const res = await fetch(`/modules/excursions/backend/api/routes.php?id=${routeId}`,{
        method:'PUT',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({ polyline: latlngs })
      });
      if(res.ok) alert('Маршрут сохранён!');
      else       alert('Ошибка сохранения: '+res.status);
    } catch(e){
      console.error('Сетевая ошибка:',e);
      alert('Не удалось сохранить маршрут');
    }
  }
})();
