<?php
// modules/excursions/backend/routes_map.php
// Админка: вкладка "Маршрут" — рисование линии маршрута

// Отображаем ошибки
ini_set('display_errors',1);
error_reporting(E_ALL);
?>
<!DOCTYPE html>
<html lang="ru">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Менеджер экскурсий — Маршрут</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet@1.9.3/dist/leaflet.css" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet-draw@1.0.4/dist/leaflet.draw.css" />
  <style>
    html, body { margin:0; padding:0; height:100vh; display:flex; }
    #map { flex:1; min-height:0; }
    #controls { padding:10px; text-align:right; background:#fff; border-left:1px solid #ccc; }
    button { padding:8px 16px; font-size:16px; margin-left:8px; }
    @media (max-width:767px) {
      html, body { flex-direction:column; }
      #map { height:60vh; }
      #controls { height:40vh; }
    }
  </style>
</head>
<body>
  <div id="map"></div>
  <div id="controls">
    <button id="saveRoute">Сохранить маршрут</button>
    <button id="cancelRoute">Отмена</button>
    <button id="toPoi">Далее: Точки интереса</button>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/leaflet@1.9.3/dist/leaflet.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/leaflet-draw@1.0.4/dist/leaflet.draw.js"></script>
  <script>
  (function(){
    const params = new URLSearchParams(window.location.search);
    const routeId = params.get('id');
    const apiUrl = '/modules/excursions/backend/api/routes.php' + (routeId? '?id='+routeId : '');

    // Инициализация карты
    const map = L.map('map').setView([47.7261, 10.3172], 13);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
      attribution: '© OpenStreetMap contributors', maxZoom:19
    }).addTo(map);

    // FeatureGroup для редактирования
    const drawnItems = new L.FeatureGroup().addTo(map);
    const drawControl = new L.Control.Draw({
      edit: { featureGroup: drawnItems },
      draw: { polygon:false, rectangle:false, circle:false, marker:false, circlemarker:false }
    });
    map.addControl(drawControl);

    // Загрузка существующего маршрута
    if(routeId) {
      fetch(apiUrl)
        .then(r=>r.ok? r.json(): Promise.reject())
        .then(data=>{
          if(data.polyline) {
            const coords = JSON.parse(data.polyline).map(p=>[p[1], p[0]]);
            const poly = L.polyline(coords, { color:'blue' });
            drawnItems.addLayer(poly);
            map.fitBounds(poly.getBounds());
          }
        }).catch(()=>{});
    }

    // События рисования
    map.on(L.Draw.Event.CREATED, e=>{
      drawnItems.clearLayers();
      drawnItems.addLayer(e.layer);
    });

    // Обработчики кнопок
    document.getElementById('saveRoute').onclick = async ()=>{
      if(!routeId) return alert('Не указан id экскурсии');
      if(drawnItems.getLayers().length===0) return alert('Нарисуйте маршрут');
      const poly = drawnItems.getLayers()[0];
      const latlngs = poly.getLatLngs().map(ll=>[ll.lng, ll.lat]);
      const fd = new FormData();
      fd.append('polyline', JSON.stringify(latlngs));
      const res = await fetch(apiUrl, { method:'PUT', body:fd });
      if(res.ok) {
        // после сохранения автоматически переходим к POI
        window.location.href = '/modules/excursions/backend/routes_poi.php?id='+routeId;
      }
      else alert('Ошибка сохранения: '+res.status);
    };

    document.getElementById('cancelRoute').onclick = ()=>{
      if(confirm('Отменить изменения маршрута?')) window.location.href='/modules/excursions/backend/routes_admin.php';
    };

    document.getElementById('toPoi').onclick = ()=>{
      if(!routeId) return alert('Сначала сохраните маршрут');
      window.location.href = '/modules/excursions/backend/routes_poi.php?id='+routeId;
    };

  })();
  </script>
</body>
</html>
