<!DOCTYPE html>
<html lang="ru">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Клиент: Мониторинг поездки</title>
  <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
  <style>
    body, html { margin: 0; padding: 0; height: 100%; }
    #map { width: 100%; height: 80%; }
    #info { padding: 10px; font-family: Arial, sans-serif; }
  </style>
</head>
<body>
  <!-- Регистрация Service Worker и подписка на Push -->
  <script>
    // Функция преобразования Base64URL в Uint8Array
    function urlBase64ToUint8Array(base64String) {
      const padding = '='.repeat((4 - base64String.length % 4) % 4);
      const base64 = (base64String + padding)
        .replace(/-/g, '+')
        .replace(/_/g, '/');
      const rawData = window.atob(base64);
      const outputArray = new Uint8Array(rawData.length);
      for (let i = 0; i < rawData.length; ++i) {
        outputArray[i] = rawData.charCodeAt(i);
      }
      return outputArray;
    }

    if ('serviceWorker' in navigator && 'PushManager' in window) {
      window.addEventListener('load', async () => {
        try {
          // 1) Регистрируем Service Worker
          const reg = await navigator.serviceWorker.register('/service-worker.js');
          console.log('Service Worker зарегистрирован с областью:', reg.scope);

          // 2) Ждём активации воркера
          await navigator.serviceWorker.ready;

          // 3) Запрашиваем разрешение
          const permission = await Notification.requestPermission();
          console.log('Permission:', permission);
          if (permission !== 'granted') {
            console.warn('Уведомления не разрешены');
            return;
          }

          // 4) Подписываемся на Push
          const publicKey = 'BH1cnQjIAukNwEJDyO-0_7WyKgIhFGK-QenONs5zNZ3FJcGMPTHci00weioHwZCry338glYjgcMJzDPYMXU3cNQ';

          // Проверочный лог
          console.log('Raw publicKey:', publicKey);
          console.log('Length:', publicKey.length);
          const arr = urlBase64ToUint8Array(publicKey);
          console.log('Uint8Array:', arr);
          console.log('Uint8Array length:', arr.length);

          const applicationServerKey = arr;
          const subscription = await reg.pushManager.subscribe({
            userVisibleOnly: true,
            applicationServerKey
          });
          console.log('Push подписка:', subscription);

          // 5) Отправляем подписку
          const clientId = 1; // заменить на динамический client_id
          await fetch('/save_subscription.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ client_id: clientId, subscription: subscription.toJSON() })
          });
          console.log('Подписка отправлена на сервер');
        } catch (err) {
          console.error('Ошибка при подписке на Push:', err);
        }
      });
    }
  </script>

  <div id="map"></div>
  <div id="info">
    <strong>Статус поездки:</strong> <span id="status">загрузка...</span><br/>
    <strong>Последние координаты:</strong> <span id="coords">–</span>
  </div>

  <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
  <script>
    const tripId = new URLSearchParams(location.search).get('trip_id') || '3';
    const pickupLat = 47.7260;
    const pickupLng = 10.3150;
    const alertRadius = 10000;
    const map = L.map('map').setView([pickupLat, pickupLng], 12);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { attribution: '&copy; OpenStreetMap contributors' }).addTo(map);
    L.marker([pickupLat, pickupLng]).addTo(map).bindPopup('Точка подачи');
    L.circle([pickupLat, pickupLng], { radius: alertRadius, color: 'blue', fill: false }).addTo(map);
    let marker;
    async function updateTrip() {
      try {
        const res = await fetch(`/get_trip.php?trip_id=${tripId}`);
        const json = await res.json();
        if (!json.success) throw new Error(json.error || 'Unknown error');
        document.getElementById('status').textContent = json.trip.status;
        if (json.position) {
          const lat = parseFloat(json.position.lat);
          const lng = parseFloat(json.position.lng);
          document.getElementById('coords').textContent = `${lat.toFixed(6)}, ${lng.toFixed(6)}`;
          const distance = map.distance([pickupLat, pickupLng], [lat, lng]);
          if (distance <= alertRadius) {
            if (marker) marker.setLatLng([lat, lng]);
            else {
              marker = L.marker([lat, lng]).addTo(map).bindPopup('Ваша машина');
              map.setView([lat, lng], 13);
            }
          }
        }
      } catch (err) {
        console.error('Ошибка при обновлении данных поездки:', err);
      }
    }
    updateTrip();
    setInterval(updateTrip, 10000);
  </script>
</body>
</html>
