<?php
// arrive_trip.php
header('Content-Type: application/json');
require_once __DIR__ . '/config/db.php';

// Получаем данные из тела запроса
$body = json_decode(file_get_contents('php://input'), true);
$tripId = isset($body['trip_id']) ? (int)$body['trip_id'] : 0;
if (!$tripId) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Missing trip_id']);
    exit;
}

// Меняем статус поездки на 'arrived' и обновляем время
$stmt = $pdo->prepare(
    'UPDATE trips SET status = :status, updated_at = NOW() WHERE id = :tripId'
);
$stmt->execute([
    ':status' => 'arrived',
    ':tripId' => $tripId
]);

// Отправляем JSON-ответ
echo json_encode(['success' => true, 'trip_id' => $tripId]);

// Отправляем SMS-уведомление о прибытии через наш service
$ch = curl_init('https://v.centrx.eu/send_sms.php');
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
    'trip_id' => $tripId,
    'event'   => 'arrived'
]));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

// Необязательно: логирование $response
?>
