#!/bin/bash

BASE_URL="https://v.centrx.eu/session.php"
TEST_ID="ABC123"
NONEXIST="INVALID_ID"

echo "=== Тест 1: существующая сессия (${TEST_ID}) ==="
curl -s -o /tmp/session_ok.html -w "HTTP_STATUS: %{http_code}\n" "${BASE_URL}?id=${TEST_ID}"
HTTP1=$(tail -n1 /tmp/session_ok.html)
if grep -q "Ошибка: не указан session" /tmp/session_ok.html; then
  echo "  ❌ В ответе было сообщение об ошибке 'не указан session'"
elif grep -q "Сессия не найдена" /tmp/session_ok.html; then
  echo "  ❌ В ответе было 'Сессия не найдена' – возможно, неверный TEST_ID или sessions.json"
elif [[ "$HTTP1" == *"200"* ]]; then
  echo "  ✅ HTTP 200, контент session.php отдан (проверьте файл /tmp/session_ok.html на наличие PWA-интерфейса)."
else
  echo "  ❌ Ожидался HTTP 200, получили: $HTTP1"
fi

echo
echo "=== Тест 2: отсутствие параметра id ==="
curl -s -o /tmp/session_noparam.html -w "HTTP_STATUS: %{http_code}\n" "${BASE_URL}"
HTTP2=$(tail -n1 /tmp/session_noparam.html)
if grep -q "Ошибка: не указан session" /tmp/session_noparam.html; then
  echo "  ✅ Появилось сообщение 'Ошибка: не указан session', как и должно быть."
else
  echo "  ❌ Ожидалось 'Ошибка: не указан session', получили:"
  tail -n5 /tmp/session_noparam.html
fi

echo
echo "=== Тест 3: несуществующая сессия (${NONEXIST}) ==="
curl -s -o /tmp/session_notfound.html -w "HTTP_STATUS: %{http_code}\n" "${BASE_URL}?id=${NONEXIST}"
HTTP3=$(tail -n1 /tmp/session_notfound.html)
if grep -q "Сессия не найдена" /tmp/session_notfound.html; then
  echo "  ✅ Появилось сообщение 'Сессия не найдена', как и должно быть."
else
  echo "  ❌ Ожидалось 'Сессия не найдена', получили:"
  tail -n5 /tmp/session_notfound.html
fi

# Удаляем временные файлы
rm -f /tmp/session_ok.html /tmp/session_noparam.html /tmp/session_notfound.html
