<?php
// post_message.php
header('Content-Type: application/json');

$sessionsFile = __DIR__ . '/sessions.json';

// Читаем тело POST-запроса (ожидаем JSON)
$input = json_decode(file_get_contents('php://input'), true);
$sessionId = $input['session'] ?? '';
$from      = $input['from']    ?? '';
$text      = $input['text']    ?? '';
$audioB64  = $input['audio']   ?? '';

// Проверяем обязательные поля
if (!$sessionId || !$from || !$text) {
    http_response_code(400);
    echo json_encode(['error' => 'Недостаточно данных (session, from, text обязательны)']);
    exit;
}

// Файл sessions.json должен существовать и быть доступен на запись
if (!file_exists($sessionsFile)) {
    http_response_code(500);
    echo json_encode(['error' => 'sessions.json не найден']);
    exit;
}

// Загружаем все сессии
$sessionsJson = file_get_contents($sessionsFile);
$sessions = json_decode($sessionsJson, true);
if (!isset($sessions[$sessionId])) {
    http_response_code(404);
    echo json_encode(['error' => 'Сессия не найдена']);
    exit;
}

// Убедимся, что для этой сессии есть массив "messages"
if (!isset($sessions[$sessionId]['messages']) || !is_array($sessions[$sessionId]['messages'])) {
    $sessions[$sessionId]['messages'] = [];
}

// Формируем новое сообщение
$id = intval(microtime(true) * 1000); // миллисекунды с плавающей точкой
$message = [
    'id'    => $id,
    'from'  => $from,
    'text'  => $text,
    'audio' => $audioB64  // строка Base64 (может быть пустой)
];

// Добавляем сообщение в конец массива
$sessions[$sessionId]['messages'][] = $message;

// Сохраняем обратно в sessions.json
file_put_contents($sessionsFile, json_encode($sessions, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));

// Отправляем ответ с ID нового сообщения
echo json_encode(['status' => 'ok', 'id' => $id]);
