<?php
// check_fk.php - проверка наличия внешнего ключа fk_trips_vehicle
require_once __DIR__ . '/config/db.php';
header('Content-Type: application/json');

try {
    $sql = "SELECT CONSTRAINT_NAME, TABLE_NAME, COLUMN_NAME, REFERENCED_TABLE_NAME, REFERENCED_COLUMN_NAME
            FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
            WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'trips' AND CONSTRAINT_NAME = 'fk_trips_vehicle'";
    $stmt = $pdo->query($sql);
    $fk = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if (empty($fk)) {
        echo json_encode(['exists' => false, 'message' => 'Внешний ключ fk_trips_vehicle не найден']);
    } else {
        echo json_encode(['exists' => true, 'foreign_key' => $fk]);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
