<?php
// modules/excursions/backend/routes_admin.php
// Админка: Менеджер экскурсий (список опубликованных и черновиков)

// Включаем отображение ошибок
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
?>
<!DOCTYPE html>
<html lang="ru">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Менеджер экскурсий</title>
  <style>
    body { font-family: Arial, sans-serif; margin:20px; }
    header { display:flex; justify-content:space-between; align-items:center; margin-bottom:20px; }
    section { margin-bottom:20px; }
    select, button { font-size:16px; padding:8px; }
    ul { padding:0; list-style:none; }
    li { margin-bottom:10px; }
    .btn { margin-left:5px; cursor:pointer; }
    a#createRoute { font-size:16px; padding:8px 12px; background:#007bff; color:#fff; text-decoration:none; border-radius:4px; }
  </style>
</head>
<body>
  <header>
    <h1>Менеджер экскурсий</h1>
    <!-- Прямая ссылка на форму создания экскурсии -->
    <a id="createRoute"
       href="/modules/excursions/backend/routes_form.php?new=1">
      + Создать новую экскурсию
    </a>
  </header>

  <section>
    <h2>Опубликованные экскурсии</h2>
    <select id="publishedRoutes">
      <option value="">-- Выберите экскурсию --</option>
    </select>
  </section>

  <section>
    <h2>Черновики</h2>
    <ul id="draftList"></ul>
  </section>

  <script>
    const apiUrl = '/modules/excursions/backend/api/admin_routes.php';

    async function loadRoutes() {
      try {
        const res = await fetch(apiUrl);
        if (!res.ok) throw new Error('Ошибка ' + res.status);
        const routes = await res.json();

        const publishedSelect = document.getElementById('publishedRoutes');
        const draftList = document.getElementById('draftList');
        publishedSelect.innerHTML = '<option value="">-- Выберите экскурсию --</option>';
        draftList.innerHTML = '';

        routes.forEach(route => {
          if (route.status === 'published') {
            const opt = document.createElement('option');
            opt.value = route.id;
            opt.textContent = `${route.name} (${route.duration})`;
            publishedSelect.append(opt);
          } else {
            const li = document.createElement('li');
            li.innerHTML = `
              <strong>${route.name}</strong> (${route.duration})
              <button class="btn editBtn" data-id="${route.id}">Редактировать</button>
              <button class="btn deleteBtn" data-id="${route.id}">Удалить</button>
            `;
            draftList.append(li);
          }
        });

        publishedSelect.addEventListener('change', () => {
          const id = publishedSelect.value;
          if (id) window.location.href = `/modules/excursions/backend/routes_form.php?id=${id}`;
        });

        draftList.querySelectorAll('.editBtn').forEach(btn => {
          btn.addEventListener('click', () => {
            const id = btn.dataset.id;
            window.location.href = `/modules/excursions/backend/routes_form.php?id=${id}`;
          });
        });

        draftList.querySelectorAll('.deleteBtn').forEach(btn => {
          btn.addEventListener('click', async () => {
            if (!confirm('Удалить черновик?')) return;
            const id = btn.dataset.id;
            const delRes = await fetch(apiUrl + '?id=' + id, { method: 'DELETE' });
            if (delRes.status === 204) loadRoutes();
            else alert('Ошибка удаления: ' + delRes.status);
          });
        });

      } catch (err) {
        alert('Ошибка загрузки маршрутов: ' + err.message);
      }
    }

    // Инициализация
    loadRoutes();
  </script>
</body>
</html>
