// modules/excursions/frontend/sw.js
const CACHE_NAME = 'excursion-cache-v1';

self.addEventListener('install', event => {
  self.skipWaiting();
});

self.addEventListener('activate', event => {
  event.waitUntil(
    caches.keys().then(keys => Promise.all(
      keys.filter(key => key !== CACHE_NAME)
          .map(key => caches.delete(key))
    ))
  );
  self.clients.claim();
});

self.addEventListener('message', event => {
  if (event.data.action === 'download') {
    caches.open(CACHE_NAME)
      .then(cache => cache.addAll(event.data.urls))
      .catch(err => console.error('Cache addAll error:', err));
  }
});

self.addEventListener('fetch', event => {
  const url = new URL(event.request.url);

  // Direct fetch for OSM tiles
  if (url.hostname === 'tile.openstreetmap.org') {
    event.respondWith(fetch(event.request));
    return;
  }

  // Stale-while-revalidate for other resources
  event.respondWith(
    caches.match(event.request).then(cachedResponse => {
      const fetchPromise = fetch(event.request)
        .then(networkResponse => {
          // Only cache full 200 responses
          if (networkResponse && networkResponse.status === 200) {
            caches.open(CACHE_NAME)
              .then(cache => cache.put(event.request, networkResponse.clone()))
              .catch(err => console.error('Cache put error:', err));
          }
          return networkResponse.clone();
        })
        .catch(() => cachedResponse);
      return cachedResponse || fetchPromise;
    })
  );
});
