<?php
// modules/maps/backend/update_position.php
header('Content-Type: application/json');

// Подключаем базу (поднимаемся на три уровня вверх к config/db.php)
require_once __DIR__ . '/../../../config/db.php';

// Читаем JSON-тело запроса
$body = file_get_contents('php://input');
$data = json_decode($body, true);
if (!is_array($data) || !isset($data['driver_id'], $data['lat'], $data['lng'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'error' => 'Invalid payload']);
    exit;
}

$driverId = (int)$data['driver_id'];
$lat      = (float)$data['lat'];
$lng      = (float)$data['lng'];
$ts       = time();

try {
    // Находим активный рейс водителя
    $stmt = $pdo->prepare("
        SELECT id 
          FROM trips
         WHERE driver_id = :driver_id
           AND status = 'en_route'
         ORDER BY scheduled_time DESC
         LIMIT 1
    ");
    $stmt->execute([':driver_id' => $driverId]);
    $trip = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$trip) {
        // Активный рейс не найден
        echo json_encode(['status' => 'no_active_trip']);
        exit;
    }

    $tripId = (int)$trip['id'];

    // Вставляем новую точку
    $stmt = $pdo->prepare("
        INSERT INTO positions (trip_id, lat, lng, timestamp)
        VALUES (:trip_id, :lat, :lng, :ts)
    ");
    $stmt->execute([
        ':trip_id' => $tripId,
        ':lat'     => $lat,
        ':lng'     => $lng,
        ':ts'      => $ts
    ]);

    echo json_encode(['status' => 'ok', 'trip_id' => $tripId]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'error' => $e->getMessage()]);
}
