#!/bin/bash

# Скрипт для создания ветки feature/maps и структуры папок для модуля карт

# 1. Переход на основную ветку (
#    Здесь предполагается, что основная ветка называется "develop". 
#    Если у вас другая, замените на нужное имя.

echo "Переключаемся на ветку develop..."
git checkout develop

echo "Обновляем локальный репозиторий..."
git pull origin develop

# 2. Создание новой ветки feature/maps
BRANCH_NAME="feature/maps"
echo "Создаём новую ветку $BRANCH_NAME и переключаемся на неё..."
git checkout -b $BRANCH_NAME

# 3. Создание структуры папок для модуля карт
MODULE_DIR="modules/maps"
echo "Создаём папки для модуля карт в $MODULE_DIR..."

# Основные папки
mkdir -p $MODULE_DIR/frontend
mkdir -p $MODULE_DIR/backend
mkdir -p $MODULE_DIR/config
mkdir -p $MODULE_DIR/docs

echo "Структура папок создана:" 
find $MODULE_DIR -type d

# 4. Инициализация файлов-заглушек
README_FILE="$MODULE_DIR/README.md"
if [ ! -f "$README_FILE" ]; then
    echo "# Модуль карт (Maps Module)" > "$README_FILE"
    echo "Здесь описывайте назначение, структуру и способ подключения модуля карт." >> "$README_FILE"
    echo "README.md создан."  
fi

echo "Готово! Теперь вы на ветке '$BRANCH_NAME' с папками для разработки модуля карт."
